// /////////////////////////////////////////////////////////////////////////////
// DR DOBB'S CHALLENGES
//
// Filename       : EntityCar.cpp
// Date           : February 2008
//
// Description    : Refer to description in corresponding header.
//
// ///////////////////////////////////////////////////////////////////////////


#include "EntityCar.h"
#include "Level.h"
#include "Application.h"




EntityCar::EntityCar() 
{

  m_MoveCarriedObjectFlags = Dobbs::DIR_DIRECTED_MOVE;
  m_Moving = false;
  m_CanBeCarried    = true;

  m_Z = 0.9f;

  m_DisplayOffset.x = 31;
  m_DisplayOffset.y = 34;

  SetRect( &m_CollisionRect, -27, -27, 27, 0 );

  SetFrame( Dobbs::ANIM_CAR );

}



EntityCar::~EntityCar() 
{
}



void EntityCar::OnEvent( const EntityEvent Event, int Param1, int Param2, const std::string& TextParam, Entity* pEntity )
{

  switch ( Event )
  {
    case EE_BLOCKED_LEFT:
      SetDirection( Dobbs::DIR_RIGHT );
      break;
    case EE_BLOCKED_RIGHT:
      SetDirection( Dobbs::DIR_LEFT );
      break;
    case EE_CARRY:
      m_Moving = true;
      m_Direction = pEntity->Direction();
      break;
    case EE_DROP:
      break;
    case EE_LAND:
      g_App.PlaySound( "Player.Land" );
      break;
  }
  Entity::OnEvent( Event, Param1, Param2, TextParam, pEntity );

}



void EntityCar::UpdateTimed( Level& aLevel, float ElapsedTime )
{

  Entity::UpdateTimed( aLevel, ElapsedTime );
  if ( m_Moving )
  {
    if ( m_Direction == Dobbs::DIR_RIGHT )
    {
      Move( aLevel, 220.0f * ElapsedTime, 0.0f, Dobbs::DIR_RIGHT );
    }
    else if ( m_Direction == Dobbs::DIR_LEFT )
    {
      Move( aLevel, -220.0f * ElapsedTime, 0.0f, Dobbs::DIR_LEFT );
    }
  }

}